/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.FrontEnd;

import io.globalcopy.client.CopyEntry;
import io.globalcopy.client.CopyRetriever;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class CopyEntryViewer
extends JFrame {
    private CopyRetriever retriever;
    private JTextField authorField;
    private JButton searchButton;
    private JTable resultsTable;
    private DefaultTableModel tableModel;

    public void setRetriever(CopyRetriever retriever) {
        this.retriever = retriever;
    }

    public void createUI() {
        this.setTitle("Copy Entry Viewer");
        this.setDefaultCloseOperation(3);
        this.setSize(600, 400);
        this.setLayout((LayoutManager)new BorderLayout());
        this.authorField = new JTextField();
        this.add((Component)this.authorField, (Object)"North");
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Author");
        this.tableModel.addColumn("Data");
        this.tableModel.addColumn("Timestamp");
        for (CopyEntry entry : this.retriever.getClipboard()) {
            this.tableModel.addRow(new Object[]{entry.author, entry.data, entry.timestamp});
        }
        this.resultsTable = new JTable(this.tableModel);
        this.add((Component)new JScrollPane(this.resultsTable), (Object)"Center");
    }

    public void updateTableData() {
        this.tableModel.setRowCount(0);
        for (CopyEntry entry : this.retriever.getClipboard()) {
            this.tableModel.addRow(new Object[]{entry.author, entry.data, entry.timestamp});
        }
        this.tableModel.fireTableDataChanged();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(CopyEntryViewer::new);
    }
}

