/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client;

import io.globalcopy.client.ClipboardSync;
import io.globalcopy.client.CopyEntry;
import io.globalcopy.client.CopyRetriever;
import io.globalcopy.client.PropertyGenerator;
import io.globalcopy.client.RequestSender;
import io.globalcopy.client.WindowsLinuxRetriever;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Properties;
import java.util.Scanner;

public class ClientMain {
    public static void main(String[] args) throws Exception {
        RequestSender requestSender = new RequestSender();
        File propFile = args.length > 0 ? ("default".equals(args[0]) ? new File("user.properties") : new File(args[0])) : new File("user.properties");
        Scanner in = new Scanner(System.in);
        if (!propFile.isFile()) {
            System.out.print("Please enter a username: ");
            String username = in.next();
            System.out.println();
            System.out.print("Please enter a password: ");
            String password1 = in.next();
            System.out.println();
            System.out.print("Please enter your password again: ");
            String password2 = in.next();
            String link = null;
            if (args.length == 2) {
                link = args[1];
                System.out.println("Using link " + link);
            } else {
                link = "http://globalcopy.io";
            }
            Properties appProps = new Properties();
            PropertyGenerator.generateNewPropertyFile((String)propFile.getPath(), (String)username, (String)link, (String)password1);
            appProps.load(new FileInputStream(propFile.getPath()));
            requestSender = new RequestSender(appProps);
            System.out.println("Created account with status " + requestSender.sendCreateRequest(appProps));
            CopyEntry firstEntry = new CopyEntry(OffsetDateTime.now(), "init");
            firstEntry.construct(appProps.getProperty("author"));
            requestSender.sendPostReq(firstEntry);
        }
        Properties appProps = new Properties();
        try {
            appProps.load(new FileInputStream(propFile.getPath()));
            WindowsLinuxRetriever winlin = new WindowsLinuxRetriever();
            requestSender = new RequestSender(appProps);
            requestSender.sendLoginRequest();
            ClipboardSync cbs = new ClipboardSync(requestSender, (CopyRetriever)winlin);
            cbs.initViewer();
            cbs.toggleSync();
            cbs.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

