/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client;

import io.globalcopy.FrontEnd.CopyEntryViewer;
import io.globalcopy.client.CopyEntry;
import io.globalcopy.client.CopyRetriever;
import io.globalcopy.client.RequestSender;
import java.io.IOException;
import java.util.ArrayList;

public class ClipboardSync
extends Thread {
    Integer SYNC_REFRESH_TIME = 1000;
    RequestSender requester;
    CopyRetriever retriever;
    boolean syncEnabled = false;
    private CopyEntryViewer viewer;

    public ClipboardSync(RequestSender requestor, CopyRetriever retriever) {
        this.retriever = retriever;
        this.requester = requestor;
        try {
            ArrayList lastSession = this.requester.sendGetAllReq();
            if (!lastSession.isEmpty()) {
                this.retriever.setClipboard(lastSession);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void initViewer() {
        this.viewer = new CopyEntryViewer();
        this.viewer.setRetriever(this.retriever);
        this.viewer.createUI();
        this.viewer.setVisible(true);
    }

    public void checkSync() throws Exception {
        CopyEntry recentRequest = this.requester.sendGetReq();
        if (recentRequest == null) {
            System.out.println("request failed, retrying");
            return;
        }
        if (!this.retriever.getLastentry().compareTo(recentRequest) && this.retriever.getLastentry().getTimestamp().isBefore(recentRequest.timestamp)) {
            this.retriever.addNewClipboardEntry(recentRequest);
        }
        if (this.retriever.fixDesync()) {
            this.requester.sendPostReq(this.retriever.getLastentry());
        }
        if (this.viewer != null) {
            this.viewer.updateTableData();
        }
    }

    @Override
    public void run() {
        while (this.syncEnabled) {
            try {
                this.checkSync();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                Thread.sleep(this.SYNC_REFRESH_TIME.intValue());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void toggleSync() {
        this.syncEnabled = !this.syncEnabled;
    }
}

