/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.globalcopy.client.CopyEntry;
import io.globalcopy.security.Encryptor;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class RequestSender {
    private Properties appprops;
    private HttpClient client = HttpClient.newHttpClient();
    private Encryptor encryptor;
    private String token;
    private String author;
    private String link = "http://localhost:8080";
    private ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);

    public RequestSender(HttpClient cli, String token, Encryptor encryptor, String author) {
        this.client = cli;
        this.encryptor = encryptor;
        this.token = token;
        this.author = author;
    }

    public RequestSender(String link, String token, Encryptor encryptor) {
        this.link = link;
        this.encryptor = encryptor;
        this.token = token;
        this.author = this.author;
    }

    public RequestSender(Properties appProps) {
        this.appprops = appProps;
        this.author = this.appprops.getProperty("author");
        this.link = this.appprops.getProperty("link");
        this.encryptor = new Encryptor(appProps, new IvParameterSpec(new byte[16]));
    }

    public int sendCreateRequest(Properties appprops) throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/signup")).method("POST", HttpRequest.BodyPublishers.noBody()).header("username", appprops.getProperty("author")).header("pw1", appprops.getProperty("key")).header("pw2", appprops.getProperty("key")).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        this.token = "Bearer " + res.headers().firstValue("Authorization").orElse("");
        return this.client.send(req, HttpResponse.BodyHandlers.ofString()).statusCode();
    }

    public int sendGenerateReq() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/generate")).GET().build();
        return this.client.send(req, HttpResponse.BodyHandlers.ofString()).statusCode();
    }

    public CopyEntry sendGetReq() throws Exception {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/history/1")).method("GET", HttpRequest.BodyPublishers.noBody()).header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        List temp = (List)this.mapper.readValue(res.body(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        CopyEntry entry = null;
        if (!temp.isEmpty()) {
            entry = (CopyEntry)temp.get(0);
            entry.setData(this.encryptor.decryptData(entry.data));
            return entry;
        }
        return entry;
    }

    public ArrayList<CopyEntry> sendGetAllReq() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/history")).method("GET", HttpRequest.BodyPublishers.noBody()).header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        if (res.body().isEmpty()) {
            return new ArrayList<CopyEntry>();
        }
        List temp = (List)this.mapper.readValue(res.body(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (CopyEntry entry : temp) {
            try {
                entry.data = this.encryptor.decryptData(entry.data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (ArrayList)temp;
    }

    public String sendHeadReq() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/hello")).method("HEAD", HttpRequest.BodyPublishers.noBody()).header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        Optional<String> lastModifiedHeader = res.headers().firstValue("last-modified");
        OffsetDateTime lastModified = (OffsetDateTime)this.mapper.readValue((String)lastModifiedHeader.orElse(null), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return lastModified.toString();
    }

    public boolean sendPostReq(CopyEntry entry) throws Exception {
        entry.construct(this.author);
        CopyEntry toSend = CopyEntry.builder().timestamp(entry.timestamp).author(this.author).data(this.encryptor.encryptData(entry.data)).tag(entry.tag).build();
        String requestBody = this.mapper.writeValueAsString((Object)toSend);
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/post")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", this.token).build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        return res.statusCode() == HttpStatus.CREATED.value();
    }

    public String sendLoginRequest() throws IOException, InterruptedException {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.link + "/api/v0/login/process")).POST(HttpRequest.BodyPublishers.noBody()).header("username", this.appprops.getProperty("author")).header("password", this.appprops.getProperty("key")).header("Content-Type", "application/json").header("Accept", "application/json").build();
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        this.token = "Bearer " + res.headers().firstValue("Authorization").orElse("");
        return res.body();
    }

    public RequestSender() {
    }
}

