/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.filters;

import io.globalcopy.managers.IGlobalCopyUserMngr;
import io.globalcopy.managers.JwtService;
import io.globalcopy.models.GlobalCopyUser;
import io.globalcopy.wrappers.HttpServletAddParamRequest;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    private final JwtService jwtService;
    @Qualifier(value="GlobalCopyUserMngr")
    private final IGlobalCopyUserMngr userService;

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        GlobalCopyUser userDetails;
        HttpServletAddParamRequest paramRequest = new HttpServletAddParamRequest(req);
        String authHeader = paramRequest.getHeader("Authorization");
        if (StringUtils.isEmpty((CharSequence)authHeader) || !StringUtils.startsWithIgnoreCase((CharSequence)authHeader, (CharSequence)"Bearer ")) {
            filterChain.doFilter((ServletRequest)paramRequest, (ServletResponse)response);
            return;
        }
        String jwt = authHeader.substring(7);
        String username = this.jwtService.extractUserName(jwt);
        if (!StringUtils.isEmpty((CharSequence)authHeader) && SecurityContextHolder.getContext().getAuthentication() == null) {
            userDetails = this.userService.loadUserByUsername(username);
            if (null == userDetails) {
                return;
            }
        } else {
            return;
        }
        log.info("User - {}", (Object)userDetails);
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
        authToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails((HttpServletRequest)paramRequest));
        context.setAuthentication((Authentication)authToken);
        SecurityContextHolder.setContext((SecurityContext)context);
        paramRequest.setParameter("Author", userDetails.getUsername());
        filterChain.doFilter((ServletRequest)paramRequest, (ServletResponse)response);
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    public JwtAuthenticationFilter(JwtService jwtService, IGlobalCopyUserMngr userService) {
        this.jwtService = jwtService;
        this.userService = userService;
    }
}

