/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.managers;

import io.globalcopy.dtos.JwtAuthenticationResponse;
import io.globalcopy.dtos.SignInRequest;
import io.globalcopy.dtos.SignUpRequest;
import io.globalcopy.managers.IGlobalCopyUserMngr;
import io.globalcopy.managers.JwtService;
import io.globalcopy.models.GlobalCopyPerm;
import io.globalcopy.models.GlobalCopyUser;
import io.globalcopy.repositories.UserRepository;
import java.util.Set;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationService {
    private final UserRepository userRepository;
    @Qualifier(value="GlobalCopyUserMngr")
    private final IGlobalCopyUserMngr userService;
    private final PasswordEncoder passwordEncoder;
    private final JwtService jwtService;
    private final AuthenticationManager authenticationManager;

    public JwtAuthenticationResponse signup(SignUpRequest request) {
        GlobalCopyUser user = GlobalCopyUser.builder().username(request.getUsername()).pwhash(this.passwordEncoder.encode((CharSequence)request.getPassword())).grantedAuthorities(Set.of(GlobalCopyPerm.USER)).isEnabled(true).build();
        user = this.userService.createUser(user);
        String jwt = this.jwtService.generateToken((UserDetails)user);
        return JwtAuthenticationResponse.builder().token(jwt).build();
    }

    public JwtAuthenticationResponse signin(SignInRequest request) {
        try {
            GlobalCopyUser user = this.userService.loadUserByUsername(request.getUsername());
            String jwt = this.jwtService.generateToken((UserDetails)user);
            System.out.println(user.getUsername());
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getUsername(), (Object)request.getPassword()));
            return JwtAuthenticationResponse.builder().token(jwt).build();
        }
        catch (UsernameNotFoundException unfe) {
            throw new IllegalArgumentException("Invalid email or password");
        }
    }

    public AuthenticationService(UserRepository userRepository, IGlobalCopyUserMngr userService, PasswordEncoder passwordEncoder, JwtService jwtService, AuthenticationManager authenticationManager) {
        this.userRepository = userRepository;
        this.userService = userService;
        this.passwordEncoder = passwordEncoder;
        this.jwtService = jwtService;
        this.authenticationManager = authenticationManager;
    }
}

