/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.rest;

import io.globalcopy.client.CopyEntry;
import io.globalcopy.client.CopyEntryRepository;
import io.globalcopy.client.PropertyGenerator;
import io.globalcopy.security.Encryptor;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v0"})
public class GlobalHistoryRest {
    @Autowired
    private CopyEntryRepository copyEntryRepository;

    public GlobalHistoryRest(CopyEntryRepository copyEntryRepository) {
        this.copyEntryRepository = copyEntryRepository;
    }

    @GetMapping(value={"/history"})
    public ResponseEntity<List<CopyEntry>> historyAt(@RequestParam(value="Author") String author) {
        List allEntries = this.copyEntryRepository.findAll();
        ArrayList<CopyEntry> matches = new ArrayList<CopyEntry>();
        for (int i = allEntries.size() - 1; i > -1; --i) {
            if (!((CopyEntry)allEntries.get((int)i)).author.equals(author)) continue;
            matches.add((CopyEntry)allEntries.get(i));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("last-modified", !matches.isEmpty() ? ((CopyEntry)matches.get((int)0)).timestamp.toString() : "N/A");
        return new ResponseEntity(matches, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/history/{num}"})
    public ResponseEntity<List<CopyEntry>> historyAtSpecification(@PathVariable Long num, @RequestParam(value="Author") String author) {
        List allEntries = (List)this.historyAt(author).getBody();
        if (allEntries == null || num > (long)allEntries.size()) {
            return new ResponseEntity((Object)allEntries, (HttpStatusCode)HttpStatus.CREATED);
        }
        ArrayList<CopyEntry> history = new ArrayList<CopyEntry>();
        int i = 0;
        while ((long)i < num) {
            history.add((CopyEntry)allEntries.get(i));
            ++i;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("last-modified", !history.isEmpty() ? ((CopyEntry)history.get((int)0)).timestamp.toString() : "N/A");
        return new ResponseEntity(history, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/history/{num}"})
    public ResponseEntity<List<CopyEntry>> deleteHistoryAtSpecification(@RequestParam(value="Author") String author, @PathVariable Long num) {
        List allEntries = (List)this.historyAt(author).getBody();
        if (allEntries == null || num > (long)allEntries.size()) {
            return new ResponseEntity((Object)allEntries, (HttpStatusCode)HttpStatus.CREATED);
        }
        ArrayList history = new ArrayList();
        int entrySize = allEntries.size();
        int i = 0;
        while ((long)i < num) {
            this.copyEntryRepository.delete((Object)((CopyEntry)allEntries.get(entrySize - i - 1)));
            ++i;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("last-modified", !history.isEmpty() ? ((CopyEntry)history.get((int)0)).timestamp.toString() : "N/A");
        return new ResponseEntity(history, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<List<CopyEntry>> getCopyEntries(@RequestParam(value="Author") String author) {
        List allEntries = this.copyEntryRepository.findAll();
        HttpHeaders headers = new HttpHeaders();
        headers.add("last-modified", !allEntries.isEmpty() ? ((CopyEntry)allEntries.get((int)0)).timestamp.toString() : "N/A");
        return new ResponseEntity((Object)allEntries, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/generate"})
    public void generateAccounts() {
        CopyEntry entry2 = null;
        try {
            Properties appProps = PropertyGenerator.generateNewPropertyInstance((String)"Vuk", (String)"http://localhost:8080", (String)"password");
            Encryptor encryptor1 = new Encryptor(appProps, new IvParameterSpec(new byte[16]));
            entry2 = CopyEntry.builder().timestamp(OffsetDateTime.of(LocalDate.of(2023, 11, 9), LocalTime.of(0, 0, 0), OffsetDateTime.now().getOffset())).data(encryptor1.encryptData("new copy")).author("Vuk").build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.copyEntryRepository.save((Object)entry2);
    }

    @PostMapping(value={"/post"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<CopyEntry> create(@RequestBody CopyEntry newEntry) throws SQLException {
        this.copyEntryRepository.save((Object)newEntry);
        return new ResponseEntity((Object)newEntry, (HttpStatusCode)HttpStatus.CREATED);
    }
}

