/*
 * Decompiled with CFR 0.152.
 */
package io.globalcopy.security;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryptor {
    SecretKey key;
    SecretKey hmacKey;
    private final IvParameterSpec paramSpec;

    public Encryptor(Properties appProps, IvParameterSpec spec) {
        this.paramSpec = spec;
        byte[] encodedKey = Base64.getDecoder().decode((String)appProps.get("key"));
        byte[] encodedHMAC = Base64.getDecoder().decode((String)appProps.get("hmac"));
        this.key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        this.hmacKey = new SecretKeySpec(encodedHMAC, 0, encodedHMAC.length, "HmacSHA256");
    }

    public String encryptData(String data) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)this.key, this.paramSpec);
        byte[] encryptedBytes = cipher.doFinal(data.getBytes());
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.hmacKey);
        byte[] hmac = mac.doFinal(encryptedBytes);
        byte[] combined = new byte[encryptedBytes.length + hmac.length];
        System.arraycopy(encryptedBytes, 0, combined, 0, encryptedBytes.length);
        System.arraycopy(hmac, 0, combined, encryptedBytes.length, hmac.length);
        return Base64.getEncoder().encodeToString(combined);
    }

    public static SecretKey generateAESKey(String keyString) throws Exception {
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        byte[] key = sha.digest(keyString.getBytes(StandardCharsets.UTF_8));
        byte[] keyBytes = Arrays.copyOf(key, 16);
        return new SecretKeySpec(keyBytes, "AES");
    }

    public String decryptData(String encryptedData) throws Exception {
        byte[] combined = Base64.getDecoder().decode(encryptedData);
        byte[] encryptedBytes = new byte[combined.length - 32];
        byte[] hmac = new byte[32];
        System.arraycopy(combined, 0, encryptedBytes, 0, encryptedBytes.length);
        System.arraycopy(combined, encryptedBytes.length, hmac, 0, hmac.length);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.hmacKey);
        byte[] expectedHmac = mac.doFinal(encryptedBytes);
        if (!Arrays.equals(expectedHmac, hmac)) {
            throw new Exception("HMAC verification failed");
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)this.key, this.paramSpec);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes);
    }

    public static SecretKey generateHMACKey(String key) {
        return new SecretKeySpec(key.getBytes(), "HmacSHA256");
    }
}

